package org.msh.tb.export_rest.dbreader;

import org.jboss.seam.international.Messages;
import org.msh.tb.entities.enums.MessageKey;

/**
 * Created by rmemoria on 11/7/17.
 */
public class SQLField {

    private String field;
    private String title;
    private Class<? extends Enum> enumClass;

    public SQLField(String field, String title, Class<? extends Enum> enumClass) {
        this.field = field;
        this.title = title;
        this.enumClass = enumClass;
    }

    public SQLField() {
        super();
    }

    /**
     * If applicable, convert the raw value read from the database to a another value
     *
     * @param value
     * @return
     */
    public Object convertRawValue(Object value) {
        if (enumClass != null) {
            return convertEnumValue(value);
        }

        if (value instanceof Boolean) {
            return value != null && (Boolean) value ? "Sim" : "";
        }
        return value;
    }

    protected Object convertEnumValue(Object value) {
        Enum e;
        Enum[] enums = enumClass.getEnumConstants();

        if (value instanceof Number) {
            int index = ((Number) value).intValue();
            if (index >= enums.length) {
                return null;
            }
            e = enums[index];
        } else if (value instanceof Enum) {
            e = (Enum) value;
        } else {
            return value;
        }

        return e instanceof MessageKey ?
                Messages.instance().get(((MessageKey) e).getMessageKey()) :
                Messages.instance().get(enumClass.getSimpleName() + "." + e.toString());
    }

    public String getField() {
        return field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Class<? extends Enum> getEnumClass() {
        return enumClass;
    }

    public void setEnumClass(Class<? extends Enum> enumClass) {
        this.enumClass = enumClass;
    }
}
